uniform sampler2D image;
uniform sampler2D reflection;

void main()
{
    vec2 texCoords = gl_TexCoord[0].xy;
    vec2 reflectionCoords = gl_TexCoord[1].xy;
    
    vec4 baseColor = texture2D(image, texCoords);
    vec4 reflectionColor = texture2D(reflection, reflectionCoords);
    
    float refectionVal = 1.0 - baseColor.a;
    
    vec4 combined = mix(baseColor, reflectionColor, refectionVal);
    
    
    combined.a = 1.0;

	gl_FragColor = combined;
}
